/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.boxes;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.boxes.AbstractBox;
import de.willuhn.jameica.gui.internal.action.FileClose;
import de.willuhn.jameica.gui.internal.action.PluginInstall;
import de.willuhn.jameica.gui.internal.action.PluginListOpen;
import de.willuhn.jameica.gui.internal.views.Settings;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.InfoPanel;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.messaging.PluginCacheMessageConsumer;
import de.willuhn.jameica.messaging.PluginMessage;
import de.willuhn.jameica.plugin.PluginLoader;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;

public class FirstStart
extends AbstractBox {
    private MessageConsumer mc = new MyMessageConsumer();

    @Override
    public String getName() {
        return "Jameica: " + Application.getI18n().tr("Erster Start");
    }

    @Override
    public boolean isActive() {
        return this.isEnabled();
    }

    @Override
    public boolean isEnabled() {
        PluginLoader loader = Application.getPluginLoader();
        return loader.getInstalledPlugins().size() == 0 && loader.getInitErrors().size() == 0;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    public int getDefaultIndex() {
        return 0;
    }

    @Override
    public void paint(Composite parent) throws RemoteException {
        I18N i18n = Application.getI18n();
        boolean pending = PluginCacheMessageConsumer.getCache().size() > 0;
        InfoPanel panel = new InfoPanel();
        String title = null;
        String text = null;
        if (pending) {
            title = "Plugin noch nicht aktiviert";
            text = "Bitte starten Sie Jameica jetzt neu.";
        } else {
            title = "Noch keine Plugins installiert";
            text = "Bitte klicken Sie auf \"Plugin installieren...\", um ein bereits heruntergeladenes Plugin hinzuzuf\u00fcgen.\nOder klicken Sie auf \"Plugins online suchen...\", um ein Plugin online herunterzuladen";
        }
        panel.setTitle(i18n.tr(title));
        panel.setText(i18n.tr(text));
        panel.setIcon("package-x-generic-medium.png");
        if (pending) {
            panel.addButton(new Button(i18n.tr("Jameica beenden"), new FileClose(), null, true, "window-close.png"));
        }
        panel.addButton(new Button(i18n.tr("Plugins online suchen..."), new PluginListOpen(), null, false, "document-save.png"));
        panel.addButton(new Button(i18n.tr("Plugin installieren..."), new PluginInstall(), null, true, "emblem-package.png"));
        panel.paint(parent);
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Application.getMessagingFactory().unRegisterMessageConsumer(FirstStart.this.mc);
            }
        });
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        @Override
        public Class[] getExpectedMessageTypes() {
            return new Class[]{PluginMessage.class};
        }

        @Override
        public void handleMessage(Message message) throws Exception {
            PluginMessage msg = (PluginMessage)message;
            if (msg.getEvent() == PluginMessage.Event.INSTALLED) {
                GUI.startView(Settings.class, (Object)1);
            }
        }

        @Override
        public boolean autoRegister() {
            return false;
        }
    }
}

